#include "Config.h"

volatile __16_type	gu16v_MemData;
volatile	u16  gu16_CorrCount;
volatile	u16  gu16_CorrCount2;
volatile __byte_type  gu8_System_flag;
void	fun_SysInit()
{
	fun_Ram_CLear();			
	//	WDT	Init
	SETWDTTimer_4096MS();
	//	LCD Init
	_pbs1	=	0b11111111;	//
	_pcs0	=	0b11111111;	//
	_pcs1	=	0b11111111; //SEG0~SEG11
	_lcdc 	=	0b10000101;	//SET COM2, Pump ,LCD Enable

	//	Beep Init
	_pas0	=	0b11000000;	//PA3->CTP
	_pas1	=	0b00000011; //PA4->CTPB
	
	_ctmc0	=	0b00000001;
	_ctmc1	=	0b00110001;

	_ctmal	=	Beep_3_2_kHZ%256;
	_ctmah	=	Beep_3_2_kHZ/256;
	
	//	Key	Init
	KEY_PORTC	=	1;
	KEY_PORT	=	1;
	KEY_PORT_PULL	=	1;
	KEY_PORT_WAKEUP	=	1;
	//unused IO set input MODE Pull up	
	_papu=0xff;
	_pbpu=0xff;
	_pcpu=0xff;	
	// Time Base 0
	SETTimerBASE0_512MS();
	SETTimerBASE0_ISR_ENABLE();
	SETTimerBASE0_ON();
	gu8v_Beep_Mode = 0;		
	// Time Base 1	
	SETTimerBASE1_64MS();
	SETTimerBASE1_ISR_ENABLE();
	SETTimerBASE1_ON();	
	_tb1f=0;
	_emi	=	1;
	
	// R-C ADC	
	Select_RC_TYPE_ADC_Converter_Mode();
	R_to_F_OSC_Source_Output0();
	TimerA_at_TimerMode();
	TimerB_CLK_Source_R_to_F_OSC();
	ADC_Mode_Interrupt_Source_TIMA();
	R_to_F_ADC_ISR_DISABLE();

	gu8v_Beep_Mode=1;
	//	PowerOn Init	
	fun_LCD_Full(0x07);		//	Full LCD
	delay_n_ms(500);
	GCC_CLRWDT();
	fun_Read_eeprom_K_Para();		//	get K parameter
	fun_LCD_Full(0x00);		//	Full LCD
	if( gu16v_MemData.U16 )
	{
		LCD_Number_Display(gu16v_MemData.U16,DOT_POSTION);		
	}
	else
	{
		LCD_Display_Lo();//"Lo"
	}
}

void fun_PowerOn_Calibrate_Detect()
{
	u8 volatile lu8v_key_time=0;
	do
	{
		GCC_CLRWDT();
		gu16_CorrCount++;
		if(gu16_CorrCount > memory_data_on_1s)//103
		{
			gu16_CorrCount = 0;
			gu8v_SysMode = Temperature_Measure_Mode;		
			break;
		}
		if(KEY_PORT == 1)
		{
			gu8v_KeyCount	= 0;
			gbv_Flag_Key_Lock	= 1;
		}
		else if(gbv_Flag_Key_Lock)
		{
			gu8v_KeyCount ++;
			if(gu8v_KeyCount > key_debounce1_40ms)
			{
				lu8v_key_time++;
				gu8v_KeyCount = 0;
				gbv_Flag_Key_Lock = 0;
				
				gu16_CorrCount = 0;
			}
			
		}		
		if(lu8v_key_time > 4)	//按???按五次
		{
			gu16_CorrCount	= 0;
			gu8v_SysMode = Temperature_Calibrate_Mode;
			gu16v_correction_K.U16=10000;
			break;
		}		
		delay_n_ms(5);
	}while(TRUE);
}

void fun_Read_eeprom_K_Para()
{
	#ifdef use_Calibrate_Temp
	__16_type 	gu16v_correction_K1,gu16v_correction_K2,gu16v_correction_K3;
	gu16v_correction_K1.byte.byte0=fun_eeprom_Read(0);
	gu16v_correction_K1.byte.byte1=fun_eeprom_Read(1);
	gu16v_correction_K2.byte.byte0=fun_eeprom_Read(2);
	gu16v_correction_K2.byte.byte1=fun_eeprom_Read(3);
	gu16v_correction_K3.byte.byte0=fun_eeprom_Read(4);
	gu16v_correction_K3.byte.byte1=fun_eeprom_Read(5);	
	if(gu16v_correction_K1.U16 == gu16v_correction_K2.U16)
	{		
		gu16v_correction_K.U16=gu16v_correction_K1.U16;
		fun_eeprom_Write(4,gu16v_correction_K.byte.byte0);       //保存Rt 系?K
		fun_eeprom_Write(5,gu16v_correction_K.byte.byte1);									
	}	
	else if(gu16v_correction_K1.U16 == gu16v_correction_K3.U16)
	{
		gu16v_correction_K.U16=gu16v_correction_K1.U16;
		fun_eeprom_Write(2,gu16v_correction_K.byte.byte0);       //保存Rt 系?K
		fun_eeprom_Write(3,gu16v_correction_K.byte.byte1);									

	}
	else if(gu16v_correction_K2.U16 == gu16v_correction_K3.U16)
	{
		gu16v_correction_K.U16=gu16v_correction_K2.U16;
		fun_eeprom_Write(0,gu16v_correction_K.byte.byte0);       //保存Rt 系?K
		fun_eeprom_Write(1,gu16v_correction_K.byte.byte1);									

	}
	else
	{
		gu16v_correction_K.U16 =10000;		
	}
	if(gu16v_correction_K.U16 ==0xffff)//未校準
	{
		gu16v_correction_K.U16 =10000;			
	}
	#else
		gu16v_correction_K.U16 =10000;
	#endif

}


void	fun_Halt()
{
	_rtmrf			 =	0;	
	GCC_CLRWDT();
	_lcdc 	=	0;	//Disable	LCD
	_cton	=	0;	//Disable	Beep
	_tb0on	=	0;	//Disable	TB Time
	_tb1on	=	0;
	_adcr	=	0;	//Disable	RC AD
	_tmrc	=	0;
	_wdtc	=	0b10101111;
	_fiden=0;
	//unused IO set input MODE Pull up
	if( gbv_Flag_Key_SET_HALT == 1)
	{
		gbv_Flag_Key_SET_HALT=0;
		fun_Wait_KEY_UP();
	}	
	GCC_HALT();	
	_ctmal=0x55;
	_ctmah=0x00;
	_papu=gu16v_MemData.byte.byte1;
	_pbpu=gu16v_MemData.byte.byte0;			
}



